namespace win
	#include "windows.bi"
end namespace
using win
#include "resource.bi"
'' simply comment this line if you get collisions... wasn't defined in my
'' headers
const GPTR = (GMEM_FIXED Or GMEM_ZEROINIT)

declare function WinMain ( _
	byval hInstance as win.hInstance, _
	byval hPrevInstance as win.hInstance, _
	byval lpCmdLine as win.LPSTR, _
	byval nCmdShow as integer ) as integer
end WinMain( win.GetModuleHandle( NULL ), NULL, command, SW_NORMAL )

function DlgProc( _
	byval hwnd as win.HWND, _
	byval msg as win.UINT, _
	byval wParam as win.WPARAM, _
	byval lParam as win.LPARAM) as win.BOOL
	
	select case msg
		case WM_INITDIALOG
			'' This is where we set up the dialog box, and initialise any default values

			win.SetDlgItemText(hwnd, IDC_TEXT, strptr("This is a string"))
			win.SetDlgItemInt(hwnd, IDC_NUMBER, 5, FALSE)
		case WM_COMMAND
			select case LOWORD(wParam)
				case IDC_ADD
				scope
					'' When somebody clicks the Add button, first we get the number of
					'' they entered

					dim as win.BOOL bSuccess
					dim as integer nTimes = win.GetDlgItemInt(hwnd, IDC_NUMBER, @bSuccess, FALSE)
					if(bSuccess <> 0) then 
						'' Then we get the string they entered
						'' First we need to find out how long it is so that we can
						'' allocate some memory

						dim as integer winlen = win.GetWindowTextLength(win.GetDlgItem(hwnd, IDC_TEXT))
						if(winlen > 0) then
							'' Now we allocate, and get the string into our buffer

							dim as integer i
							dim as zstring ptr buf

							buf = cast( zstring ptr, win.GlobalAlloc(GPTR, winlen + 1) )
							win.GetDlgItemText(hwnd, IDC_TEXT, buf, winlen + 1)

							'' Now we add the string to the list box however many times
							'' the user asked us to.
							
							for i as integer = 0 to nTimes - 1
								dim as integer index = win.SendDlgItemMessage(hwnd, IDC_LIST, LB_ADDSTRING, 0, cast(win.lParam, buf) )

								'' Here we are associating the value nTimes with the item 
								'' just for the heck of it, we'll use it to display later.
								'' Normally you would put some more useful data here, such
								'' as a pointer.
								win.SendDlgItemMessage(hwnd, IDC_LIST, LB_SETITEMDATA, cast( win.WPARAM, index), cast(win.LPARAM, nTimes) )
							next
							
							'' Dont' forget to free the memory!
							win.GlobalFree(cast(win.HANDLE, buf))
						else 
							win.MessageBox(hwnd, strptr("You didn't enter anything!"), strptr("Warning"), MB_OK)
						end if
					else
						win.MessageBox(hwnd, strptr("Couldn't translate that number :("), strptr("Warning"), MB_OK)
					end if
				end scope
				case IDC_REMOVE
				scope
					'' When the user clicks the Remove button, we first get the number
					'' of selected items

					dim as win.HWND hList = win.GetDlgItem(hwnd, IDC_LIST)
					dim as integer count = win.SendMessage(hList, LB_GETSELCOUNT, 0, 0)
					if(count <> LB_ERR) then
						if(count <> 0) then
							'' And then allocate room to store the list of selected items.

							dim as integer i
							dim as integer ptr buf = win.GlobalAlloc(GPTR, sizeof(integer ptr) * count)
							win.SendMessage(hList, LB_GETSELITEMS, cast(win.WPARAM,count), cast(win.LPARAM,buf))
							
							'' Now we loop through the list and remove each item that was
							'' selected.  

							'' WARNING!!!  
							'' We loop backwards, because if we removed items
							'' from top to bottom, it would change the indexes of the other
							'' items!!!

							for i as integer = count - 1 to 0 step -1
								win.SendMessage(hList, LB_DELETESTRING, cast(win.WPARAM, buf[i]), 0)
							next

							win.GlobalFree(buf)
						else 
							win.MessageBox(hwnd, strptr("No items selected."), strptr("Warning"), MB_OK)
						end if
					else
						win.MessageBox(hwnd, strptr("Error counting items :("), strptr("Warning"), MB_OK)
					end if
				end scope
				case IDC_CLEAR
					win.SendDlgItemMessage(hwnd, IDC_LIST, LB_RESETCONTENT, 0, 0)
				case IDC_LIST
					select case HIWORD(wParam)
						case LBN_SELCHANGE
						scope
							'' Get the number of items selected.

							dim as win.HWND hList = win.GetDlgItem(hwnd, IDC_LIST)
							dim as integer count = win.SendMessage(hList, LB_GETSELCOUNT, 0, 0)
							if(count <> LB_ERR) then
								'' We only want to continue if one and only one item is
								'' selected.

								if(count = 1) then
									'' Since we know ahead of time we're only getting one
									'' index, there's no need to allocate an array.

									dim as integer index
									dim as integer winerr = win.SendMessage(hList, LB_GETSELITEMS, cast(win.WPARAM,1), cast(win.LPARAM, @index) )
									if(winerr <> LB_ERR) then
										'' Get the data we associated with the item above
										'' (the number of times it was added)

										dim as integer windata = win.SendMessage(hList, LB_GETITEMDATA, cast(win.WPARAM,index), 0)

										win.SetDlgItemInt(hwnd, IDC_SHOWCOUNT, windata, FALSE)
									else 
										win.MessageBox(hwnd, strptr("Error getting selected item :("), strptr("Warning"), MB_OK)
									end if
								else 
									'' No items selected, or more than one
									'' Either way, we aren't going to process this.
									win.SetDlgItemText(hwnd, IDC_SHOWCOUNT, strptr("-"))
								end if
							else
								win.MessageBox(hwnd, strptr("Error counting items :("), strptr("Warning"), MB_OK)
							end if
						end scope
					end select
			end select
		case WM_CLOSE
			win.EndDialog(hwnd, 0)
		case else
			return FALSE
	end select
	return TRUE
	
end function


function WinMain ( _
	byval hInstance as win.hInstance, _
	byval hPrevInstance as win.hInstance, _
	byval lpCmdLine as win.LPSTR, _
	byval nCmdShow as integer ) as integer
	
	return DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, @DlgProc())
end function
